#!/usr/bin/env bash

set -e

#
# This script is a temporary work-around to allow us to test Kubernetes changes locally.
# Eventually this script's contents will be converted to a Jenkinsfile.
# Do not "source" the app.env file in this script as that script should only be used for the old "3 jobs" build pipeline.
#

echo -e "\nSourcing set-dev-env.sh\n"
source ./nextgen/set-dev-env.sh

# Start the nextgen stack
echo -e "\nStarting nextgen-stack"
pushd ../nextgen-stack
./run-all.sh
popd

echo -e "\nSourcing nextgen-stack/set-dev-envars.sh\n"
source ../nextgen-stack/set-dev-envars.sh

# These variables will be defined and set in the Jenkinsfile that deploys the image
# Other environment variables include: $NAMESPACE, $VAMF_ENVIRONMENT
export AWS_LOGIN=true
export DTR_URL=${DTR_URL:-$DTR_URL_AWS}
export IMAGE=images/fit-heart
export IMAGE_PULL_SECRET=${IMAGE_PULL_SECRET:-$IMAGE_PULL_SECRET_AWS}
export SERVICE_VERSION=latest

echo -e "\nSetting environment variables in Consul"
./nextgen/set-consul-vars.sh || { echo "FATAL: Failed to set environment variables in Consul. Make sure Consul is running"; exit 1; }

echo -e "\nStart VA FitHeart containers\n"
envsubst <./kubernetes/deployment.yml | kubectl apply -f -
envsubst <./kubernetes/service.yml | kubectl apply -f -

echo "Waiting for VA FitHeart to be ready"
while true; do
  # Look for specific services so that problems with other service categories - staff, vet, etc. - don't affect this check
  numNotRunning=`kubectl get pods | egrep "fit-heart" | grep -v "NAME" | egrep -v "Running|Evicted" | wc -l`
  if [[ numNotRunning -eq 0 ]];
    then
        break;
  fi
  sleep 5
  printf "."
done
echo -e "\nVA FitHeart is running\n"

echo -e "\nRegister VA FitHeart application services with Consul"
./nextgen/register_services.sh || { echo "FATAL: Failed to register VA FitHeart application services with Consul. Make sure Consul is running"; exit 1; }
